//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
class stTree
{
    public:
        int     info;
        stTree  *left,
                *right;
};
//+------------------------------------------------------------------+
stTree *store(stTree *root, stTree *r, int info)
{
    if (r == NULL)
    {
        r = new stTree;

        (*r).left = NULL;
        (*r).right = NULL;
        (*r).info = info;
        if (root == NULL) return r;
        if (info < (*root).info) (*root).left = r;
        else (*root).right = r;

        return r;
    }
    if (info < (*r).info) return store(r, (*r).left, info);
    return store(r, (*r).right, info);
}
//+------------------------------------------------------------------+
string inorder(stTree *root)
{
    static string sz0 = "In Order: ";

    if (root == NULL) return sz0;

    inorder((*root).left);
    sz0 += (root != NULL ? StringFormat("%d  ", (*root).info) : "");
    inorder((*root).right);

    return sz0;
}
//+------------------------------------------------------------------+
string preorder(stTree *root)
{
    static string sz0 = "Pre Order: ";

    if (root == NULL) return sz0;

    sz0 += (root != NULL ? StringFormat("%d  ", (*root).info) : "");
    preorder((*root).left);
    preorder((*root).right);

    return sz0;
}
//+------------------------------------------------------------------+
string postorder(stTree *root)
{
    static string sz0 = "Post Order: ";

    if (root == NULL) return sz0;

    postorder((*root).left);
    postorder((*root).right);
    sz0 += (root != NULL ? StringFormat("%d  ", (*root).info) : "");

    return sz0;
}
//+------------------------------------------------------------------+
void OnStart(void)
{
    stTree *root = NULL;

    root = store(root, root, 10);
    store(root, root, -6);
    store(root, root, 47);
    store(root, root, 35);
    store(root, root, 85);

    Print(inorder(root));
    Print(preorder(root));
    Print(postorder(root));
}
//+------------------------------------------------------------------+